// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 7, Aufgabe 9
// "Loesung eines linearen Gleichungssystems"

public class A9 {

	// Read a matrix of float values representing a linear equation system
	static float[][] readMatrix() {
		In.open("input.txt");
		int n = In.readInt();
		float[][] a = new float[n][n+1];
		for (int i = 0; i < n; i++)
			for (int j = 0; j <= n; j++)
				a[i][j] = In.readFloat();
		In.close();
		return a;
	}
	
	// Print a
	static void printMatrix(float[][] a) {
		for (int i = 0; i < a.length; i++) {
			for (int j = 0; j < a[0].length; j++)
				Out.print(" " + a[i][j]);
			Out.println();
		}
		Out.println();
	}
	
	// Apply Gaussian elimination to a
	static float[][] eliminate(float[][] a) {
		for (int i = 0; i < a.length; i++) {
			for (int j = i+1; j < a.length; j++) {
				float c = a[j][i] / a[i][i];
				for (int k = i; k < a[0].length; k++) {
					a[j][k] -= a[i][k] * c;
				}
			}
		}
		return a;
	}
	
	// Compute the solution vector from a
	static float[] solution(float[][] a) {
		int n = a.length;
		float[] res = new float[n];
		for (int i = n-1; i >= 0; i--) {
			for (int j = i+1; j < n; j++)
				a[i][n] -= a[i][j] * res[j];
			res[i] = a[i][n] / a[i][i];
		}
		return res;
	}

	public static void main(String args[]) {
		float[][] a = readMatrix();
		printMatrix(a);
		a = eliminate(a);
		printMatrix(a);
		float[] res = solution(a);
		for (int i = 0; i < res.length; i++)
			Out.print(" " + res[i]);
	}
}

/*
Sample input:
3
2  1 -1  6
3 -2  4  4
1  1 -2  3
*/